<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

// Load the Rest Controller library

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH.'/third_party/raz/vendor/autoload.php';
use Razorpay\Api\Api;

class Authentication extends REST_Controller {

    public function __construct() { 
        parent::__construct();
        
        // Load the user model
        $this->load->model('user');
    }
	
	
	public function advocate_by_city_get($city=0)
     {
        $adv = $this->user->get_advocate_by_city($this->input->get('city'));
        if(!empty($adv)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($adv, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }

     }
	
	

    public function Certificate_contactFrm_POST()
    {
       
        
        $name = $this->post('name');
        $city = $this->post('city');
        $email = $this->post('email');
        $mobile = $this->post('mobile');
        $address = $this->post('address');
        

        if(!empty($name) && !empty($email) && !empty($mobile) && !empty($city) && !empty($address))
        {


                 $userData = array(
                    'uname' => $name,
                    'city' => $city,
                    'email' => $email,
                    'mobile' => $mobile,
                    'address'=>$address           
                );



                 //print_r($userData);die();
                $insert = $this->user->certificate_Enquiry($userData);
                
                // Check if the user data is inserted
                if($insert){
                 $api = new Api(RAZOR_PAY_KEY_ID, RAZOR_KEY_SCRIPT);

                    $orderData = [

                        'receipt'         => 123,

                        'amount'          => 1000, // 39900 rupees in paise

                        'currency'        => RAZOR_PAY_CURRENCY
                    ];

                   $razorpayOrder = $api->order->create($orderData);
				   //print_r($razorpayOrder);
				   //die();
                    
                    $res=array(
                    'status' => TRUE,
                    'message' => 'The user has been added successfully.',    
                    'order_id'=>$razorpayOrder->id,
                    'proclee_order'=>'Proclee-'.$insert,
					'amount'=>$razorpayOrder->amount_due,
					'request_id'=>$insert
               
                   );


                    // Set the response and exit
                    $this->response([
                    
                        'data' => $res

                    ], REST_Controller::HTTP_OK);
                }else{
                    // Set the response and exit
                    $this->response("Some problems occurred, please try again.", REST_Controller::HTTP_BAD_REQUEST);
                }
            
        }else{
            // Set the response and exit
            $this->response("Provide Complete Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

    }   
    public function Doc_cat_list_get($ct_id=0)
     {
        $cat_doc = $this->user->get_doc_category($this->input->get('ct_id'));
        if(!empty($cat_doc)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($cat_doc, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }

     } 
    
    public function SaveEnquiry_POST()
    {
        
        $m_id = $this->post('m_id');
        $adv_name = $this->post('adv_name');
        $adv_city = $this->post('adv_city');
        $enquiry_for= $this->post('enquiry_for');
        $name = $this->post('name');
        $location = $this->post('location');
        $email = $this->post('email');
        $mobile = $this->post('mobile');
        

        if(!empty($name) && !empty($location) && !empty($email) && !empty($mobile) && !empty($m_id) && !empty($adv_name) && !empty($adv_city) && !empty($enquiry_for))
        {


                 $userData = array(
                    'name' => $name,
                    'location' => $location,
                    'email' => $email,
                    'mobile' => $mobile,
                    'categoryname'=>$adv_name,
                    'categoryid'=>$m_id,
                    'advocatecity'=>$adv_city,
                    'enquiry_for'=>$enquiry_for           
                );

                 //print_r($userData);die();
                $insert = $this->user->insert_Enquiry($userData);
                
                // Check if the user data is inserted
                if($insert){
                    // Set the response and exit
                    $this->response([
                        'status' => TRUE,
                        'message' => 'The user has been added successfully.',
                        'data' => $insert
                    ], REST_Controller::HTTP_OK);
                }else{
                    // Set the response and exit
                    $this->response("Some problems occurred, please try again.", REST_Controller::HTTP_BAD_REQUEST);
                }
            
        }else{
            // Set the response and exit
            $this->response("Provide Complete Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

    }   

public function save_common_enquiry_post()
  {      
        $categoryname = $this->post('categoryname');
        $name = $this->post('name');
        $location = $this->post('location');
        $email = $this->post('email');
        $mobile = $this->post('mobile');
        

        if(!empty($name) && !empty($location) && !empty($email) && !empty($mobile) && !empty($categoryname))
        {


                 $userData = array(
                    'name' => $name,
                    'location' => $location,
                    'email' => $email,
                    'mobile' => $mobile,
                    'categoryname'=>$categoryname          
                );

                 //print_r($userData);die();
                $insert = $this->user->save_laws_enquiry($userData);
                
                // Check if the user data is inserted
                if($insert){
                    // Set the response and exit
                    $this->response([
                        'status' => TRUE,
                        'message' => 'The user has been added successfully.',
                        'data' => $insert
                    ], REST_Controller::HTTP_OK);
                }else{
                    // Set the response and exit
                    $this->response("Some problems occurred, please try again.", REST_Controller::HTTP_BAD_REQUEST);
                }
            
        }else{
            // Set the response and exit
            $this->response("Provide Complete Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

    }   


    
    
public function searchcertificate_get($plot_no='',$khasra_no='',$name='',$colony_name='',$address='',$district=''){
       
       //echo $this->get('plot_no');
       //exit;
        $data = [];
        $post = $this->input->post();
         $push_condition=[];
        //$data['process_data'] =  $this->user->getdata('certificate_working');
        
           // $condition = array(
           //      'delete_status'=>1,
           // );
            $plot_no= $this->get('plot_no');
            $khasra_no=$this->get('khasra_no');
            $name=$this->get('name'); 
            $colony_name=$this->get('colony_name');    
            $address=$this->get('address');
            $district=$this->get('district');
         if(!empty($plot_no) || !empty($khasra_no) || !empty($name) || !empty($colony_name) || !empty($address) || !empty($district))
         {
            

           $condition = array(
            'plot_no' => $plot_no,
            'khasra_no' => $khasra_no,
            'name' => $name,
            'colony_name' =>$colony_name,
            'address' => $address,
            'district' => $district,
            );

           
            array_push($push_condition, $condition);
            $publicdata =  $this->user->certificatedatapulic($push_condition);
            $rera =  $this->user->certificatedatarera($push_condition);
            $courtcase =  $this->user->certificatedatacourtcase($push_condition);
            $tncp =  $this->user->certificatedatatncp($push_condition);
            $auction =  $this->user->certificatedataauction($push_condition);
         
           // if(!empty($post['word']) && $post['word'] == 'anyword'){
            //   $publicdata =  $this->Mainmodel->certificatedatapulic($condition);
            //   $rera =  $this->Mainmodel->certificatedatarera($condition);
            //   $courtcase =  $this->Mainmodel->certificatedatacourtcase($condition);
            //   $tncp =  $this->Mainmodel->certificatedatatncp($condition);
            //   $auction =  $this->Mainmodel->certificatedataauction($condition);
           // }else{
           //   $publicdata =  $this->Mainmodel->getdata('tbl_pnotice',$condition);
           //   $rera =  $this->Mainmodel->getdata('tbl_reranotice',$condition);
           //   $courtcase =  $this->Mainmodel->getdata('tbl_court',$condition);
           // }
           
           $data =  array(
                'publicdata'=>$publicdata,
                'rera'=>$rera,
                'courtcase'=>$courtcase,
                'auction'=>$auction,
                'tncp'=>$tncp,
                //'selected_plot'=>$selected_plot,
                //'selected_khasra'=>$selected_khasra
          );




         if(!empty($data))
         {
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($data, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }

       
    
      
    }
    else{
            // Set the response and exit
            $this->response("Please Provide Details.", REST_Controller::HTTP_BAD_REQUEST);
        }
}
  
  
  
public function search_auction_notice_get($plot_no='',$khasraNo='',$wordtype='',$tehsil='',$town='', $name='',$state='',$city='',$bank_name='',$from_date='',$to_date='',$address='',$colony_name='')
     {
       
        $wordtype=$this->get('wordtype');
        $plot_no=$this->get('plot_no'); 
        $khasraNo=$this->get('khasraNo'); 
        $tehsil=$this->get('tehsil');
        $town=$this->get('town');
        $name=$this->get('name');
        $address=$this->get('address');
        $state=$this->get('state');
        $city=$this->get('city');
        $bank_name=$this->get('bank_name');
        $colony_name=$this->get('colony_name'); 
        $from_date=$this->get('from_date');
        $to_date=$this->get('to_date');
 
        
      if($wordtype=='anyword')
      { 
        

       if(!empty($plot_no) || !empty($khasraNo) || !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($bank_name) || !empty($name) || !empty($state) || !empty($city) || !empty($from_date) || !empty($to_date) || !empty($address))
       {
        $rera_notice = $this->user->get_auction_notice($plot_no,$khasraNo,$colony_name,$tehsil,$town,$name,$bank_name,$state,$city,$from_date,$to_date,$address);
        //$users = $this->user->getRows($con);                  
        if(!empty($rera_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($rera_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
   }

else{
            // Set the response and exit
            $this->response("Provide Provide Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

     }
      
      if($wordtype=='exact')
      { 

       if(!empty($plot_no) || !empty($khasraNo) || !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($bank_name) || !empty($name) || !empty($state) || !empty($city) || !empty($from_date) || !empty($to_date) || !empty($address))
       {
        $rera_notice = $this->user->get_exact_auction_notice($plot_no,$khasraNo,$colony_name,$tehsil,$town,$name,$bank_name,$state,$city,$from_date,$to_date,$address);
        //$users = $this->user->getRows($con);                  
        if(!empty($rera_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($rera_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
}

else{
            // Set the response and exit
            $this->response("Provide Provide Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

     } 


     } 



    
    public function login_post() {
        // Get the post data
      $email = $this->post('email');
    // $this->response([
    //                 'status' => TRUE,
    //                 'message' => 'User login successful.',
    //                 'data' => $email
    //             ], REST_Controller::HTTP_OK);
        $password = $this->post('password');
        
        // Validate the post data
        if(!empty($email) && !empty($password)){
            
            // Check if any user exists with the given credentials
            $con['returnType'] = 'single';
            $con['conditions'] = array(
                'email' => $email,
                'password' => md5($password),
                'status' => 1
            );
            $user = $this->user->getRows($con);
            
            if($user){
                // Set the response and exit
                $this->response([
                    'status' => TRUE,
                    'message' => 'User login successful.',
                    'data' => $user
                ], REST_Controller::HTTP_OK);
            }else{
                // Set the response and exit
                //BAD_REQUEST (400) being the HTTP response code
                $this->response("Wrong email or password.", REST_Controller::HTTP_BAD_REQUEST);
            }
        }else{
            // Set the response and exit
            $this->response("Provide email and password.", REST_Controller::HTTP_BAD_REQUEST);
        }
    }
    
    
    public function search_court_notice_get($respondant='',$khasraNo='',$wordtype='',$case_no='',$crn_no='',$court_name='',$colony_name='',$tehsil='',$town='',$petitioner='',$state='',$city='')
     {
       
        $respondant=$this->get('respondant');
        $khasraNo=$this->get('khasraNo');
        $wordtype=$this->get('wordtype');
        $case_no=$this->get('case_no');
        $crn_no=$this->get('crn_no');
        $court_name=$this->get('court_name');
        $colony_name=$this->get('colony_name');
        $tehsil=$this->get('tehsil');
        $town=$this->get('town');
        $petitioner=$this->get('petitioner');
        $state=$this->get('state');
        $city=$this->get('city');
 
        
      if($wordtype=='anyword')
      { 

       if(!empty($respondant) || !empty($khasraNo) || !empty($case_no) || !empty($crn_no) ||  !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($petitioner) || !empty($state) || !empty($city) || !empty($court_name))
       {
        $rera_notice = $this->user->get_court_notice($respondant,$khasraNo,$case_no,$crn_no,$court_name,$colony_name,$tehsil,$town,$petitioner,$state,$city);
        //$users = $this->user->getRows($con);                  
        if(!empty($rera_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($rera_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
   }

else{
            // Set the response and exit
            $this->response("Provide Provide Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

     }
      
      if($wordtype=='exact')
      { 

       if(!empty($respondant) || !empty($khasraNo) || !empty($case_no) || !empty($crn_no) ||  !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($petitioner) || !empty($state) || !empty($city) || !empty($court_name))
       {
        $rera_notice = $this->user->get_exact_court_notice($respondant,$khasraNo,$case_no,$crn_no,$court_name,$colony_name,$tehsil,$town,$petitioner,$state,$city);
        //$users = $this->user->getRows($con);                  
        if(!empty($rera_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($rera_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
}

else{
            // Set the response and exit
            $this->response("Provide Provide Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

     } 


     } 
    
    public function search_tncp_notice_get($plot_no='',$khasraNo='',$wordtype='',$colony_name='',$tehsil='',$town='', $project_name='',$state='',$city='',$project_address='')
     {
       
        $plot_no=$this->get('plot_no');
        $khasraNo=$this->get('khasraNo');
        $wordtype=$this->get('wordtype');
        $colony_name=$this->get('colony_name');
        $tehsil=$this->get('tehsil');
        $town=$this->get('town');
        $project_name=$this->get('project_name');
		$state=$this->get('state');
		$city=$this->get('city');
		$project_address=$this->get('project_address');

        
      if($wordtype=='anyword')
      { 
         

       if(!empty($plot_no) || !empty($khasraNo) || !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($project_name)|| !empty($state) || !empty($city) || !empty($project_address))
       {
        $tncp_notice = $this->user->get_tncp_notice($plot_no,$khasraNo,$colony_name,$tehsil,$town, $project_name,$state,$city,$project_address);
        //$users = $this->user->getRows($con);                  
        if(!empty($tncp_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($tncp_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
   }

else{
            // Set the response and exit
            $this->response("Provide Provide Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

     }
      
      if($wordtype=='exact')
      { 

       if(!empty($plot_no) || !empty($khasraNo) || !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($project_name)|| !empty($state) || !empty($city) || !empty($project_address))
       {
        $tncp_notice = $this->user->get_exact_tncp_notice($plot_no,$khasraNo,$colony_name,$tehsil,$town,$project_name,$state,$city,$project_address);
        //$users = $this->user->getRows($con);                  
        if(!empty($tncp_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($tncp_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
}

else{
            // Set the response and exit
            $this->response("Provide Provide Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

     } 


     } 
    
    public function registration_post() {
        // Get the post data
        $first_name = strip_tags($this->post('first_name'));
        $last_name = strip_tags($this->post('last_name'));
        $email = strip_tags($this->post('email'));
        $password = $this->post('password');
        $phone = strip_tags($this->post('phone'));
        
        // Validate the post data
        if(!empty($first_name) && !empty($last_name) && !empty($email) && !empty($password)){
            
            // Check if the given email already exists
            $con['returnType'] = 'count';
            $con['conditions'] = array(
                'email' => $email,
            );
            $userCount = $this->user->getRows($con);
            
            if($userCount > 0){
                // Set the response and exit
                $this->response("The given email already exists.", REST_Controller::HTTP_BAD_REQUEST);
            }else{
                // Insert user data
                $userData = array(
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                    'email' => $email,
                    'password' => md5($password),
                    'phone' => $phone
                );
                $insert = $this->user->insert($userData);
                
                // Check if the user data is inserted
                if($insert){
                    // Set the response and exit
                    $this->response([
                        'status' => TRUE,
                        'message' => 'The user has been added successfully.',
                        'data' => $insert
                    ], REST_Controller::HTTP_OK);
                }else{
                    // Set the response and exit
                    $this->response("Some problems occurred, please try again.", REST_Controller::HTTP_BAD_REQUEST);
                }
            }
        }else{
            // Set the response and exit
            $this->response("Provide complete user info to add.", REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function Save_ContactUs_post()
    {
        $name = strip_tags($this->post('name'));
        $location = strip_tags($this->post('location'));
        $email = strip_tags($this->post('email'));
        $phone = strip_tags($this->post('phone'));
        $subject = strip_tags($this->post('subject'));
        $message = strip_tags($this->post('message'));

        if(!empty($name) && !empty($location) && !empty($email) && !empty($phone) && !empty($subject) && !empty($message))
        {


                 $userData = array(
                    'name' => $name,
                    'location' => $location,
                    'email' => $email,
                    'phone' => $phone,
                    'subject'=>$subject,
                    'message'=>$message
                );
                $insert = $this->user->insert_ContactUs($userData);
                
                // Check if the user data is inserted
                if($insert){
                    // Set the response and exit
                    $this->response([
                        'status' => TRUE,
                        'message' => 'The user has been added successfully.',
                        'data' => $insert
                    ], REST_Controller::HTTP_OK);
                }else{
                    // Set the response and exit
                    $this->response("Some problems occurred, please try again.", REST_Controller::HTTP_BAD_REQUEST);
                }
            
        }else{
            // Set the response and exit
            $this->response("Provide Complete Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

    }
    
    public function user_get($id = 0) {
        // Returns all the users data if the id not specified,
        // Otherwise, a single user will be returned.
        $con = $id?array('id' => $id):'';
        $users = $this->user->getRows($con);
        
        // Check if the user data exists
        if(!empty($users)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($users, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No user was found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
    }
    
     public function Enquiry_get()
     {
        $list = $this->user->get_enquiry();
        if(!empty($list)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($list, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No user was found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }

     }
   
    public function State_list_get()
     {
        $list = $this->user->get_state_list();
        if(!empty($list)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($list, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }

     }


     public function City_list_get($sid=0)
     {
        $city_list = $this->user->get_city_list($this->input->get('sid'));
        if(!empty($city_list)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($city_list, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }

     }

    public function news_paper_list_get()
     {
        $news_paper = $this->user->get_news_paper();
        if(!empty($news_paper)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($news_paper, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }

     } 

    public function public_notice_list_get($plot_no='',$khasraNo='',$wordtype='',$news_id='',$colony_name='',$tehsil='',$town='',$state='',$city='',$nt_id='',$address='',$name='',$from_date='',$to_date='')
     {
      
       
        $plot_no=$this->get('plot_no');
        $khasraNo=$this->get('khasraNo');
        $colony_name=$this->get('colony_name');
        $tehsil=$this->get('tehsil');
        $town=$this->get('town');
        $wordtype=$this->get('wordtype');
        $state=$this->get('state');
        $city=$this->get('city');
        $news_id=$this->get('news_id');
        $nt_id=$this->get('nt_id');
        $address=$this->get('address');
        $name=$this->get('name');
		$from_date=$this->get('from_date');
        $to_date=$this->get('to_date');
      

        
      if($wordtype=='anyword')
      { 
        

       if(!empty($plot_no) || !empty($khasraNo) || !empty($news_id) || !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($state) || !empty($city) || !empty($nt_id) || !empty($address) || !empty($name) || !empty($from_date) || !empty($to_date))
       {

        $public_notice = $this->user->get_public_notice($plot_no,$khasraNo,$news_id,$colony_name,$tehsil,$town,$state,$city,$nt_id,$address,$name,$from_date,$to_date);
        
        //$users = $this->user->getRows($con);                  
        if(!empty($public_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($public_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
}

else{
            // Set the response and exit
            $this->response("Provide complete user info to add.", REST_Controller::HTTP_BAD_REQUEST);
        }

     }
      
      if($wordtype=='exact')
      { 


       if(!empty($plot_no) || !empty($khasraNo) || !empty($news_id) || !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($state) || !empty($city) || !empty($nt_id) || !empty($address) || !empty($name) || !empty($from_date) || !empty($to_date))
       {
        $public_notice = $this->user->get_exact_public_notice($plot_no,$khasraNo,$news_id,$colony_name,$tehsil,$town,$state,$city,$nt_id,$address,$name,$from_date,$to_date);
        //$users = $this->user->getRows($con);                  
        if(!empty($public_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($public_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
}

else{
            // Set the response and exit
            $this->response("Provide complete user info to add.", REST_Controller::HTTP_BAD_REQUEST);
        }

     } 



     } 

     public function public_notice_list1_get($plot_no='',$khasraNo='',$wordtype='',$news_id='',$colony_name='',$tehsil='',$town='',$state='',$city='',$nt_id='',$address='',$name='')
     {
       $condition=[];

       $conditions=array(
        $plot_no=base64_encode($this->get('plot_no')),
        $khasraNo=base64_encode($this->get('khasraNo')),
        $colony_name=base64_encode($this->get('colony_name')),
        $tehsil=base64_encode($this->get('tehsil')),
        $town=base64_encode($this->get('town')),
        $wordtype=$this->get('wordtype'),
        $state=$this->get('state'),
        $city=$this->get('city'),
        $news_id=$this->get('news_id'),
        $nt_id=$this->get('nt_id'),
        $address=base64_encode($this->get('address')),
        $name=base64_encode($this->get('name')),
        );

        array_push($condition,$conditions);
      if($wordtype=='anyword')
      { 
        

       if(!empty($condition))
       {

        $public_notice = $this->user->get_public_notice($condition);
        
        //$users = $this->user->getRows($con);                  
        if(!empty($public_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($public_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
}

else{
            // Set the response and exit
            $this->response("Provide complete user info to add.", REST_Controller::HTTP_BAD_REQUEST);
        }

     }
      
      if($wordtype=='exact')
      { 


       if(!empty($plot_no) || !empty($khasraNo) || !empty($news_id) || !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($state) || !empty($city) || !empty($nt_id) || !empty($address) || !empty($name ))
       {
        $public_notice = $this->user->get_exact_public_notice($plot_no,$khasraNo,$news_id,$colony_name,$tehsil,$town,$state,$city,$nt_id,$address,$name);
        //$users = $this->user->getRows($con);                  
        if(!empty($public_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($public_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
}

else{
            // Set the response and exit
            $this->response("Provide complete user info to add.", REST_Controller::HTTP_BAD_REQUEST);
        }

     } 



     } 


     public function search_rera_notice_get($plot_no='',$khasraNo='',$wordtype='',$rera_regno='',$colony_name='',$tehsil='',$town='',$project_name='',$state='',$city='',$address='')
     {
       
        $plot_no=$this->get('plot_no');
        $khasraNo=$this->get('khasraNo');
        $wordtype=$this->get('wordtype');
        $rera_regno=$this->get('rera_regno');
        $colony_name=$this->get('colony_name');
        $tehsil=$this->get('tehsil');
        $town=$this->get('town');
        $project_name=$this->get('project_name');
		$state=$this->get('state');
        $city=$this->get('city');
		$address=$this->get('address');
		

        
      if($wordtype=='anyword')
      { 

       if(!empty($plot_no) || !empty($khasraNo) || !empty($rera_regno) || !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($project_name) || !empty($state) || !empty($city) || !empty($address))
       {
          
        $rera_notice = $this->user->get_rera_notice($plot_no,$khasraNo,$rera_regno,$colony_name,$tehsil,$town,$project_name,$state,$city,$address);
        
        //print_r($rera_notice);
        //die();
        //$users = $this->user->getRows($con);                  
        if(!empty($rera_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($rera_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
   }

    else{
            // Set the response and exit
            $this->response("Provide Provide Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

     }
      
      if($wordtype=='exact')
      { 

       if(!empty($plot_no) || !empty($khasraNo) || !empty($rera_regno) || !empty($colony_name) || !empty($tehsil) || !empty($town) || !empty($project_name) || !empty($state) || !empty($city) || !empty($address))
       {
    $rera_notice = $this->user->get_exact_rera_notice($plot_no,$khasraNo,$rera_regno,$colony_name,$tehsil,$town,$project_name,$state,$city,$address);
        //$users = $this->user->getRows($con);                  
        if(!empty($rera_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($rera_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
}

else{
            // Set the response and exit
            $this->response("Provide Provide Details.", REST_Controller::HTTP_BAD_REQUEST);
        }

     } 


     } 


     public function legal_services_get()
     {
        $legal_services = $this->user->get_legal_services();
        if(!empty($legal_services)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($legal_services, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }

     }
     
     public function advocate_list_get()
     { 
        $advocate = $this->user->get_advocate();
        if(!empty($advocate)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($advocate, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }

     }
 
     public function legal_services_cat_get($sid='')
     {  
       
        $legal_services_cat = $this->user->get_legal_services_cat($this->input->get('sid'));
        
        if(!empty($legal_services_cat)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($legal_services_cat, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record Found',
            ], REST_Controller::HTTP_NOT_FOUND);
        }

     } 

     public function public_tncp_list_get()
     {
        $tncp_notice = $this->user->get_tncp_notices();
        if(!empty($tncp_notice)){
            // Set the response and exit
            //OK (200) being the HTTP response code
            $this->response($tncp_notice, REST_Controller::HTTP_OK);
        }else{
            // Set the response and exit
            //NOT_FOUND (404) being the HTTP response code
            $this->response([
                'status' => FALSE,
                'message' => 'No Record found.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }

     }  

     

    public function user_put() {
        $id = $this->put('id');
        
        // Get the post data
        $first_name = strip_tags($this->put('first_name'));
        $last_name = strip_tags($this->put('last_name'));
        $email = strip_tags($this->put('email'));
        $password = $this->put('password');
        $phone = strip_tags($this->put('phone'));
        
        // Validate the post data
        if(!empty($id) && (!empty($first_name) || !empty($last_name) || !empty($email) || !empty($password) || !empty($phone))){
            // Update user's account data
            $userData = array();
            if(!empty($first_name)){
                $userData['first_name'] = $first_name;
            }
            if(!empty($last_name)){
                $userData['last_name'] = $last_name;
            }
            if(!empty($email)){
                $userData['email'] = $email;
            }
            if(!empty($password)){
                $userData['password'] = md5($password);
            }
            if(!empty($phone)){
                $userData['phone'] = $phone;
            }
            $update = $this->user->update($userData, $id);
            
            // Check if the user data is updated
            if($update){
                // Set the response and exit
                $this->response([
                    'status' => TRUE,
                    'message' => 'The user info has been updated successfully.'
                ], REST_Controller::HTTP_OK);
            }else{
                // Set the response and exit
                $this->response("Some problems occurred, please try again.", REST_Controller::HTTP_BAD_REQUEST);
            }
        }else{
            // Set the response and exit
            $this->response("Provide at least one user info to update.", REST_Controller::HTTP_BAD_REQUEST);
        }
    }

}

?>